C SAMPLE PROGRAM FOR DGEFS
C
      INTEGER   LDA
      PARAMETER (LDA=10)
      DOUBLE PRECISION  A(LDA,LDA), B(LDA), WORK(LDA), RCOND
      INTEGER   IWORK(LDA), I, J, N, ITASK, IND
C
C SET UP PROBLEM
C
      N      =  3
      ITASK  =  1
      A(1,1) = 10.0D0
      A(2,1) = -3.0D0
      A(3,1) =  5.0D0
      A(1,2) = -7.0D0
      A(2,2) =  2.0D0
      A(3,2) = -1.0D0
      A(1,3) =  0.0D0
      A(2,3) =  6.0D0
      A(3,3) =  5.0D0
      B(1)   =  7.0D0
      B(2)   =  4.0D0
      B(3)   =  6.0D0
C
C PRINT PROBLEM INFORMATION
C
      WRITE (*,*) ' COEFFICIENT MATRIX ='
      DO 10 I = 1,N
         WRITE (*,800) (A(I,J), J = 1,N)
10    CONTINUE
      WRITE (*,*) ' RIGHT-HAND SIDE ='
      WRITE (*,800) (B(J), J = 1,N)
C
C SOLVE LINEAR SYSTEM
C
      CALL DGEFS (A, LDA, N, B, ITASK, IND, WORK, IWORK, RCOND)
C
C PRINT RESULTS
C
      WRITE (*,*)
      WRITE (*,*) 'DGEFS RESULTS'
      IF (IND .EQ. -10) THEN
         WRITE (*,*) ' ERROR CODE =', IND
      ELSE IF (IND .LT.0) THEN
         WRITE (*,*) ' ERROR CODE =', IND
         STOP
      ELSE
         WRITE (*,*) ' NUMBER OF ACCURATE DIGITS =', IND
      END IF
C
      WRITE (*,*) ' SOLUTION ='
      WRITE (*,800) (B(J), J = 1,N)
C
      WRITE (*,*)
      WRITE (*,*) 'REFERENCE RESULTS FROM IBM PC/AT '
      WRITE (*,*) ' NUMBER OF ACCURATE DIGITS =          14'
      WRITE (*,*) ' SOLUTION ='
      WRITE (*,*) '     0.000000000000E+00     -0.100000000000E+01',    
     *'      0.100000000000E+01'
C
      STOP
800   FORMAT (4X, D20.12, 4X, D20.12, 4X, D20.12)
      END
